﻿<%@ webhandler Language="C#" class="Upload" %>

/**
 * KindEditor ASP.NET
 *
 * 本ASP.NET程序是演示程序，建议不要直接在实际项目中使用。
 * 如果您确定直接使用本程序，使用之前请仔细确认相关安全设置。
 *
 */

using System;
using System.Collections;
using System.Web;
using System.IO;
using System.Globalization;
using LitJson;
using System.Web.UI;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using DotNet.FrameWork.Common.Images;
public class Upload : IHttpHandler
{
	//文件保存目录路径
	private String savePath = "/UpLoadImage/"+ DateTime.Now.Year.ToString()+ DateTime.Now.ToString("MM") + "/";
	//文件保存目录URL
	private String saveUrl = "/UpLoadImage/"+ DateTime.Now.Year.ToString()+ DateTime.Now.ToString("MM") + "/";
	//定义允许上传的文件扩展名
	private String fileTypes = "gif,jpg,jpeg,png,bmp";
	//最大文件大小kb
	private int maxSize = 31457280;
    private Image srcImage;
    /// <summary>
    /// 回调
    /// </summary>
    /// <returns></returns>
    public bool ThumbnailCallback()
    {
        return false;
    }
	private HttpContext context;

	public void ProcessRequest(HttpContext context)
	{
		this.context = context;

		HttpPostedFile imgFile = context.Request.Files["imgFile"];
		if (imgFile == null)
		{
			showError("请选择文件。");
		}

        String dirPath = Path.Combine(context.Request.PhysicalApplicationPath, HttpContext.Current.Server.MapPath(savePath));
		if (!Directory.Exists(dirPath))
		{
			  Directory.CreateDirectory(dirPath);
            //showError("上传目录不存在。");
		}

		String fileName = imgFile.FileName;
		String fileExt = Path.GetExtension(fileName).ToLower();
		ArrayList fileTypeList = ArrayList.Adapter(fileTypes.Split(','));

		if (imgFile.InputStream == null || imgFile.InputStream.Length > maxSize)
		{
			showError("上传文件大小超过限制。");
		}

		if (String.IsNullOrEmpty(fileExt) || Array.IndexOf(fileTypes.Split(','), fileExt.Substring(1).ToLower()) == -1)
		{
			showError("上传文件扩展名是不允许的扩展名。");
		}
        //
        //srcImage = Image.FromFile(dirPath);
        string oldefilename=DateTime.Now.ToString("HHmmss_ffff", DateTimeFormatInfo.InvariantInfo) + fileExt;
        String newFileName = DateTime.Now.ToString("HHmmssffff", DateTimeFormatInfo.InvariantInfo) + fileExt;
        String oldfilePath = dirPath + oldefilename;
        string newfilepath = dirPath + newFileName;
        //上传原图
        imgFile.SaveAs(oldfilePath);
        //返回缩略图
        //MakeThumbnailImg.MakeThumbnail(oldfilePath, newfilepath,327,249,"HW");
        //删除原图
        //if (File.Exists(oldfilePath))
        //{
        //    File.Delete(oldfilePath);
        //}
        String fileUrl = saveUrl + oldefilename;

		Hashtable hash = new Hashtable();
		hash["error"] = 0;
		hash["url"] = fileUrl;
		context.Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
		context.Response.Write(JsonMapper.ToJson(hash));
		context.Response.End();
	}
    /// <summary>
    /// 生成缩略图,返回缩略图的Image对象
    /// </summary>
    /// <param name="Width">缩略图宽度</param>
    /// <param name="Height">缩略图高度</param>
    /// <returns>缩略图的Image对象</returns>
    public Image GetImage(int Width, int Height)
    {
        Image img;
        Image.GetThumbnailImageAbort callb = new Image.GetThumbnailImageAbort(ThumbnailCallback);
        img = srcImage.GetThumbnailImage(Width, Height, callb, IntPtr.Zero);
        return img;
    }
	private void showError(string message)
	{
		Hashtable hash = new Hashtable();
		hash["error"] = 1;
		hash["message"] = message;
		context.Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
		context.Response.Write(JsonMapper.ToJson(hash));
		context.Response.End();
	}

	public bool IsReusable
	{
		get
		{
			return true;
		}
	}
}
